import {
    View,
    Text,
    FlatList,
    TouchableWithoutFeedback,
    ScrollView,
    StyleSheet,
} from "react-native";
import React from "react";
import { getbestSellers } from "../../../redux/slices/bestSellers/bestSellers";
import { useDispatch, useSelector } from "react-redux";
import { useEffect } from "react";
import { filterHomeStyle } from "./FilterHomeStyle";
import { categoriesStyle } from "../../Home/FeatureCategories/featureCategoriesStyle";
import ProgressiveImage from "../../../src/components/ProgressiveImage";
import { ProductsStyle } from "../../Home/FeaturedProducts/featureProductsStyle";
import { useNavigation } from "@react-navigation/native";
import BestSellersSkeleton from "../../../src/skeletons/screens/Search/BestSellersSkeleton";
import { BASE_API_URL_STG } from "@env";
import useLangTranslation from "../../../hooks/useLangTranslation";
import { PRODUCT_DETAILS } from "../../../components/Navigation/RouteNames";

const BestSellers = () => {
    const dispatch = useDispatch();
    const navigation = useNavigation();
    const bestSellerURL = `${BASE_API_URL_STG}/user/product-categorized/bestSeller`;
    const { trans } = useLangTranslation();
    const { bestSellers, loading: isLoading } = useSelector(
        (state) => state.bestSellers
    );
    useEffect(() => {
        if(bestSellers.length == 0) {
            dispatch(getbestSellers(bestSellerURL));
        }
    }, []);
    const productsStyle = ProductsStyle();
    const RenderItem = ({ item }) => {
        return (
            <View style={[categoriesStyle.item, filterHomeStyle.sellerItem]}>
                <TouchableWithoutFeedback
                    onPress={() => {
                        navigation.navigate(PRODUCT_DETAILS, {
                            slug: item?.slug,
                            item
                        });
                    }}
                >
                    <View>
                        <ProgressiveImage
                            source={{ uri: item.featured_image }}
                            style={productsStyle.img}
                        />
                    </View>
                </TouchableWithoutFeedback>
            </View>
        );
    };
    return (
        <>
            <Text
                style={[
                    filterHomeStyle.header,
                    filterHomeStyle.bestSellersHeader,
                ]}
            >
                {trans("Best Sellers")}
            </Text>

            <ScrollView
                keyboardShouldPersistTaps={"always"}
                showsVerticalScrollIndicator={false}
            >
                {isLoading ? (
                    <View>
                        <BestSellersSkeleton />
                    </View>
                ) : (
                    <View>
                        {bestSellers?.length > 0 ? (
                            <FlatList
                                keyboardShouldPersistTaps={"always"}
                                data={bestSellers}
                                listKey={(_, i) => "f1" + i.toString()}
                                keyExtractor={(_, i) => "s1" + i}
                                renderItem={({ item }) => (
                                    <RenderItem item={item} />
                                )}
                                showsVerticalScrollIndicator={false}
                                numColumns={3}
                                columnWrapperStyle={styles.columnWrapper}
                            />
                        ) : (
                            <View>
                                <Text>
                                    {trans("Best Sellers List is Empty")}
                                </Text>
                            </View>
                        )}
                    </View>
                )}
            </ScrollView>
        </>
    );
};

export default BestSellers;

const styles = StyleSheet.create({
    columnWrapper:{
        justifyContent: "flex-start"
    }
});
